package ga.examples.quadratic;

import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

public class QuadraticOnePointCrossoverOp extends ProbabilityOp implements
    ICrossoverOp<QuadraticIndividual> {

  public QuadraticOnePointCrossoverOp(final int pCrossover) {
    super(pCrossover);
  }

  @Override
  public IndividualList<QuadraticIndividual> crossover(
      final QuadraticIndividual individual1,
      final QuadraticIndividual individual2, final GAContext context) {
    final IndividualList<QuadraticIndividual> list = new IndividualList<QuadraticIndividual>();

    final QuadraticIndividual ind1 = individual1.clone();
    final QuadraticIndividual ind2 = individual2.clone();

    if (doOperate()) {
      final int iCut = getRandom().nextInt(QuadraticIndividual.PARAMETER_COUNT);
      for (int i = 0; i < iCut; i++) {
        // switch parameters
        ind2.getGenotype().set(i,
            ind1.getGenotype().set(i, ind2.getGenotype().get(i)));
      }
    }

    list.add(ind1);
    list.add(ind2);

    return list;
  }
}
